from __init__ import *
from werkzeug.security import generate_password_hash, check_password_hash
from datetime import date
import random


def index():
    return make_response(render_template('front/index-02.html'))


def about_us():
    return make_response(render_template('front/about.html'))


def services():
    return make_response(render_template('front/service.html'))


def single_services(id):
    service = app.config.get('SERVICES').get('services').get(id)
    form = ContactUs()
    if form.validate_on_submit():
        this_is_a_thief = request.form.get('catch-a-thief', None)
        if this_is_a_thief == None:
            SubmitRequest(form)
    return make_response(render_template('front/service-detail-02.html', service=service, form = form))

def SubmitRequest(form):
    message = form.message.data
    email = form.email.data
    name = form.name.data
    subject = f"Request from {name} on {app.config.get('PROJECT_NAME')} "
    phone = form.phone.data
    try:
        msg = Message(
            sender=(name, 'website@difaaclimited.com'),
            subject=subject,
            recipients=['info@difaaclimited.com'],
            # recipients=['mutai.tony@yahoo.com'],
            cc=[email],
            body=message + "\n\n Name: " + name + "\n Phone: " + phone + "\n Email: " + email + "\n")
        msg.html = render_template("mail/partner.html")

        mail.send(msg)
        flash('Message sent', 'info')
        # return make_response(jsonify({'success': True, 'message': 'Success'}))
    except Exception as e:
        flash(str(e), 'info')
        # return make_response(jsonify({'success': False, 'message': 'Error while sending mail!'}))

def contacts():
    form = ContactUs()
    if form.validate_on_submit():
        this_is_a_thief = request.form.get('catch-a-thief', None)
        if this_is_a_thief == None:
            SubmitRequest(form)
    return make_response(render_template('front/contact-us.html', form=form))


def services_():
    return make_response(render_template('front/service-detail-02.html'))


def gallery():
    path = 'static/images'
    images = os.listdir(path)
    # for index, file in enumerate(images):
    #     os.rename(os.path.join(path, file), os.path.join(path, ''.join([str(index), '.jpg'])))
    images = ['images/' + file for file in images]
    # print(images)
    random.shuffle(images)
    # print(images)
    return make_response(render_template('front/gallery.html', images=images))


def team():
    team = [
            {'name': 'Hassan Mohamed Hussein',
             'image': 't2.jpg',
             'email': 'gm@difaaclimited.com',
             'phone': '+254729388726',
             'post': 'General manager Nairobi Branch, Eastleigh BBS Mall LG 07'
             },
            {'name': 'Solian Botan',
             'image': 't1.jpg',
             'email': 'solian@difaaclimited.com',
             'phone': '+254712581118',
             'post': 'Nairobi Branch, Eastleigh BBS Mall LG 07'
             },
            {'name': 'Abdi Boyan',
             'image': 't2.jpg',
             'email': 'abdi@difaaclimited.com',
             'phone': '+211925556680',
             'post': 'Kampala, Uganda'
             },
            {'name': 'Abdulkadir Solian',
             'image': 't2.jpg',
             'email': 'abdulkadir@difaaclimited.com',
             'phone': '+211929349999',
             'post': 'Juba, South Sudan'
             }
        ]
    return make_response(render_template('front/team.html', team=team))


def faqs():
    return make_response(render_template('front/faq.html'))


def terms_and_condition():
    return make_response(render_template('front/term-condition.html'))


def privacy_policy():
    return make_response(render_template('front/privacy-policy.html'))


def partner():
    if request.method == 'POST':
        data = request.values
        message = data.get('message')
        email = data.get('email')
        subject = data.get('subject')
        name = data.get('name')
        phone = data.get('phone')
        try:
            msg = Message(
                sender=(name, 'partners@oilgenpetroleum.com'),
                subject=subject,
                recipients=['partners@oilgenpetroleum.com'],
                cc=[email],
                body=message + "\n\n Name: " + name + "\n Phone: " + phone + "\n Email: " + email + "\n")
            msg.html = render_template("mail/partner.html")

            mail.send(msg)
            return make_response(jsonify({'success': True, 'message': 'Success'}))
        except Exception as e:
            return make_response(jsonify({'success': False, 'message': 'Error while sending mail!'}))
    return make_response(render_template('front/partner.html'))
