from flask import *
from flask_sqlalchemy import SQLAlchemy
from flask_cors import CORS
from flask_mail import Mail, Message
import os, pymysql
from werkzeug.exceptions import HTTPException
from forms.forms import ContactUs


app = Flask(__name__, template_folder= 'templates')
app.config.from_object(__name__)

CORS(app, resources={r'/*': {'origins': '*'}})

from settings.settings import *

os.environ["OAUTHLIB_INSECURE_TRANSPORT"] = "1"

db = SQLAlchemy(app)
mail = Mail(app)

app.app_context().push()

app.config['SESSION_SQLALCHEMY'] = db

from models.models import *

@app.errorhandler(HTTPException)
def error_handler(response):
    return make_response(render_template('front/error.html',code=str(response.code),
        name=response.name,
        description=response.description,))

@app.teardown_request
def teardown_request(exception):
    if exception:
        db.session.rollback()

@app.after_request
def add_security_headers(response):
    # response.content_type = "application/json"
    return response