/**
* Pollux - Plumber, carpenter and cleaning HTML5 Template
*
* @author Webestica (https://www.webestica.com/)
* @version 1.0.0
**/


/* ===================
Table Of Content
======================
01 PRELOADER
02 MEGAMENU
03 STICKY HEADER
04 TINY SLIDER
05 BACK TO TOP
06 GLIGHTBOX
07 ISOTOPE
08 CHOICES
09 AOS ANIMATION
====================== */

"use strict";
!function () {

		window.Element.prototype.removeClass = function () {
				let className = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "",
						selectors = this;
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (this.isVariableDefined(selectors) && className) {
						selectors.classList.remove(className);
				}
				return this;
		}, window.Element.prototype.addClass = function () {
				let className = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "",
						selectors = this;
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (this.isVariableDefined(selectors) && className) {
						selectors.classList.add(className);
				}
				return this;
		}, window.Element.prototype.toggleClass = function () {
				let className = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "",
						selectors = this;
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (this.isVariableDefined(selectors) && className) {
						selectors.classList.toggle(className);
				}
				return this;
		}, window.Element.prototype.isVariableDefined = function () {
				return !!this && typeof (this) != 'undefined' && this != null;
		}
}();

// Get CSS var value
var ThemeColor = function () {
	return {
		getCssVariableValue: function (e) {
			var t = getComputedStyle(document.documentElement).getPropertyValue(e);
			return t && t.length > 0 && (t = t.trim()), t;
		}
	};
}();

var e = {
		init: function () {
				e.preLoader(),
				e.megaMenu(),
				e.stickyHeader(),
				e.tinySlider(),     
				e.backTotop(),
				e.lightBox(),
				e.enableIsotope(),
				e.choicesSelect(),
				e.aosFunc();
				
		},
		isVariableDefined: function (el) {
				return typeof !!el && (el) != 'undefined' && el != null;
		},
		getParents: function (el, selector, filter) {
				const result = [];
				const matchesSelector = el.matches || el.webkitMatchesSelector || el.mozMatchesSelector || el.msMatchesSelector;

				// match start from parent
				el = el.parentElement;
				while (el && !matchesSelector.call(el, selector)) {
						if (!filter) {
								if (selector) {
										if (matchesSelector.call(el, selector)) {
												return result.push(el);
										}
								} else {
										result.push(el);
								}
						} else {
								if (matchesSelector.call(el, filter)) {
										result.push(el);
								}
						}
						el = el.parentElement;
						if (e.isVariableDefined(el)) {
								if (matchesSelector.call(el, selector)) {
										return el;
								}
						}

				}
				return result;
		},
		getNextSiblings: function (el, selector, filter) {
				let sibs = [];
				let nextElem = el.parentNode.firstChild;
				const matchesSelector = el.matches || el.webkitMatchesSelector || el.mozMatchesSelector || el.msMatchesSelector;
				do {
						if (nextElem.nodeType === 3) continue; // ignore text nodes
						if (nextElem === el) continue; // ignore elem of target
						if (nextElem === el.nextElementSibling) {
								if ((!filter || filter(el))) {
										if (selector) {
												if (matchesSelector.call(nextElem, selector)) {
														return nextElem;
												}
										} else {
												sibs.push(nextElem);
										}
										el = nextElem;

								}
						}
				} while (nextElem = nextElem.nextSibling)
				return sibs;
		},
		on: function (selectors, type, listener) {
				document.addEventListener("DOMContentLoaded", () => {
						if (!(selectors instanceof HTMLElement) && selectors !== null) {
								selectors = document.querySelector(selectors);
						}
						selectors.addEventListener(type, listener);
				});
		},
		onAll: function (selectors, type, listener) {
				document.addEventListener("DOMContentLoaded", () => {
						document.querySelectorAll(selectors).forEach((element) => {
								if (type.indexOf(',') > -1) {
										let types = type.split(',');
										types.forEach((type) => {
												element.addEventListener(type, listener);
										});
								} else {
										element.addEventListener(type, listener);
								}


						});
				});
		},
		removeClass: function (selectors, className) {
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (e.isVariableDefined(selectors)) {
						selectors.removeClass(className);
				}
		},
		removeAllClass: function (selectors, className) {
				if (e.isVariableDefined(selectors) && (selectors instanceof HTMLElement)) {
						document.querySelectorAll(selectors).forEach((element) => {
								element.removeClass(className);
						});
				}

		},
		toggleClass: function (selectors, className) {
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (e.isVariableDefined(selectors)) {
						selectors.toggleClass(className);
				}
		},
		toggleAllClass: function (selectors, className) {
				if (e.isVariableDefined(selectors)  && (selectors instanceof HTMLElement)) {
						document.querySelectorAll(selectors).forEach((element) => {
								element.toggleClass(className);
						});
				}
		},
		addClass: function (selectors, className) {
				if (!(selectors instanceof HTMLElement) && selectors !== null) {
						selectors = document.querySelector(selectors);
				}
				if (e.isVariableDefined(selectors)) {
						selectors.addClass(className);
				}
		},
		select: function (selectors) {
				return document.querySelector(selectors);
		},
		selectAll: function (selectors) {
				return document.querySelectorAll(selectors);
		},

		
		// START: 01 Preloader
		preLoader: function () {
				window.onload = function () {
						var preloader = e.select('.preloader');
						if (e.isVariableDefined(preloader)) {
								setTimeout(function(){
										preloader.style.display = 'none';
								}, 200);
						}
				};
		},
		// END: Preloader

		// START: 02 Mega Menu
		megaMenu: function () {
				e.onAll('.dropdown-menu a.dropdown-item.dropdown-toggle', 'click', function (event) {
						var element = this;
						event.preventDefault();
						event.stopImmediatePropagation();
						if (e.isVariableDefined(element.nextElementSibling) && !element.nextElementSibling.classList.contains("show")) {
								const parents = e.getParents(element, '.dropdown-menu');
								e.removeClass(parents.querySelector('.show'), "show");
								if(e.isVariableDefined(parents.querySelector('.dropdown-opened'))){
										e.removeClass(parents.querySelector('.dropdown-opened'), "dropdown-opened");
								}

						}
						var $subMenu = e.getNextSiblings(element, ".dropdown-menu");
						e.toggleClass($subMenu, "show");
						$subMenu.previousElementSibling.toggleClass('dropdown-opened');
						var parents = e.getParents(element, 'li.nav-item.dropdown.show');
						if (e.isVariableDefined(parents) && parents.length > 0) {
								e.on(parents, 'hidden.bs.dropdown', function (event) {
										e.removeAllClass('.dropdown-submenu .show');
								});
						}
				});
		},
		// END: Mega Menu

		// START: 03 Sticky Header
		stickyHeader: function () {
			var stickyNav = e.select('.navbar-sticky');
			if (e.isVariableDefined(stickyNav)) {
					var stickyHeight = stickyNav.offsetHeight;
					stickyNav.insertAdjacentHTML('afterend', '<div id="sticky-space"></div>');
					var stickySpace = e.select('#sticky-space');
					if (e.isVariableDefined(stickySpace)) {
							document.addEventListener('scroll', function (event) {
									var scTop = window.pageYOffset || document.documentElement.scrollTop;
									if (scTop >= 400) {
											stickySpace.addClass('active');
											e.select("#sticky-space.active").style.height = stickyHeight + 'px';
											stickyNav.addClass('navbar-sticky-on');
									} else {
											stickySpace.removeClass('active');
											stickySpace.style.height = '0px';
											stickyNav.removeClass("navbar-sticky-on");
									}
							});
					}
			}
	},
	// END: Sticky Header

		// START: 04 Tiny Slider
		tinySlider: function () {
				var $carousel = e.select('.tiny-slider-inner');
				if (e.isVariableDefined($carousel)) {
					var tnsCarousel = e.selectAll('.tiny-slider-inner');
					tnsCarousel.forEach(slider => {
							var slider1 = slider;
							var sliderMode = slider1.getAttribute('data-mode') ? slider1.getAttribute('data-mode') : 'carousel';
							var sliderAxis = slider1.getAttribute('data-axis') ? slider1.getAttribute('data-axis') : 'horizontal';
							var sliderSpace = slider1.getAttribute('data-gutter') ? slider1.getAttribute('data-gutter') : 30;
							var sliderEdge = slider1.getAttribute('data-edge') ? slider1.getAttribute('data-edge') : 0;

							var sliderItems = slider1.getAttribute('data-items') ? slider1.getAttribute('data-items') : 4; //option: number (items in all device)
							var sliderItemsXl = slider1.getAttribute('data-items-xl') ? slider1.getAttribute('data-items-xl') : Number(sliderItems); //option: number (items in 1200 to end )
							var sliderItemsLg = slider1.getAttribute('data-items-lg') ? slider1.getAttribute('data-items-lg') : Number(sliderItemsXl); //option: number (items in 992 to 1199 )
							var sliderItemsMd = slider1.getAttribute('data-items-md') ? slider1.getAttribute('data-items-md') : Number(sliderItemsLg); //option: number (items in 768 to 991 )
							var sliderItemsSm = slider1.getAttribute('data-items-sm') ? slider1.getAttribute('data-items-sm') : Number(sliderItemsMd); //option: number (items in 576 to 767 )
							var sliderItemsXs = slider1.getAttribute('data-items-xs') ? slider1.getAttribute('data-items-xs') : Number(sliderItemsSm); //option: number (items in start to 575 )

							var sliderSpeed = slider1.getAttribute('data-speed') ? slider1.getAttribute('data-speed') : 500;
							var sliderautoWidth = slider1.getAttribute('data-autowidth') === 'true'; //option: true or false
							var sliderArrow = slider1.getAttribute('data-arrow') !== 'false'; //option: true or false
							var sliderDots = slider1.getAttribute('data-dots') !== 'false'; //option: true or false

							var sliderAutoPlay = slider1.getAttribute('data-autoplay') !== 'false'; //option: true or false
							var sliderAutoPlayTime = slider1.getAttribute('data-autoplaytime') ? slider1.getAttribute('data-autoplaytime') : 4000;
							var sliderHoverPause = slider1.getAttribute('data-hoverpause') === 'true'; //option: true or false
							if (e.isVariableDefined(e.select('.custom-thumb'))) {
								var sliderNavContainer = e.select('.custom-thumb');
							} 
							var sliderLoop = slider1.getAttribute('data-loop') !== 'false'; //option: true or false
							var sliderRewind = slider1.getAttribute('data-rewind') === 'true'; //option: true or false
							var sliderAutoHeight = slider1.getAttribute('data-autoheight') === 'true'; //option: true or false
							var sliderfixedWidth = slider1.getAttribute('data-fixedwidth') === 'true'; //option: true or false
							var sliderTouch = slider1.getAttribute('data-touch') !== 'false'; //option: true or false
							var sliderDrag = slider1.getAttribute('data-drag') !== 'false'; //option: true or false
							// Check if document DIR is RTL
							var ifRtl = document.getElementsByTagName("html")[0].getAttribute("dir");
							var sliderDirection;
							if (ifRtl === 'rtl') {
									sliderDirection = 'rtl';
							}

							var tnsSlider = tns({
									container: slider,
									mode: sliderMode,
									axis: sliderAxis,
									gutter: sliderSpace,
									edgePadding: sliderEdge,
									speed: sliderSpeed,
									autoWidth: sliderautoWidth,
									controls: sliderArrow,
									nav: sliderDots,
									autoplay: sliderAutoPlay,
									autoplayTimeout: sliderAutoPlayTime,
									autoplayHoverPause: sliderHoverPause,
									autoplayButton: false,
									autoplayButtonOutput: false,
									controlsPosition: top,
									navContainer: sliderNavContainer,
									navPosition: top,
									autoplayPosition: top,
									controlsText: [
											'<i class="fas fa-chevron-left"></i>',
											'<i class="fas fa-chevron-right"></i>'
									],
									loop: sliderLoop,
									rewind: sliderRewind,
									autoHeight: sliderAutoHeight,
									fixedWidth: sliderfixedWidth,
									touch: sliderTouch,
									mouseDrag: sliderDrag,
									arrowKeys: true,
									items: sliderItems,
									textDirection: sliderDirection,
									responsive: {
											0: {
													items: Number(sliderItemsXs)
											},
											576: {
													items: Number(sliderItemsSm)
											},
											768: {
													items: Number(sliderItemsMd)
											},
											992: {
													items: Number(sliderItemsLg)
											},
											1200: {
													items: Number(sliderItemsXl)
											}
									}
							});
					}); 
				}
		},
		// END: Tiny Slider

		 // START: 05 Back to Top
		backTotop: function () {
				var scrollpos = window.scrollY;
				var backBtn = e.select('.back-top');
				if (e.isVariableDefined(backBtn)) {
						var add_class_on_scroll = () => backBtn.addClass("back-top-show");
						var remove_class_on_scroll = () => backBtn.removeClass("back-top-show");

						window.addEventListener('scroll', function () {
								scrollpos = window.scrollY;
								if (scrollpos >= 800) {
										add_class_on_scroll()
								} else {
										remove_class_on_scroll()
								}
						});

						backBtn.addEventListener('click', () => window.scrollTo({
								top: 0,
								behavior: 'smooth',
						}));
				}
		},
		// END: Back to Top

		// START: 06 GLightbox
		lightBox: function () {
				var light = e.select('[data-glightbox]');
				if (e.isVariableDefined(light)) {
						var lb = GLightbox({
								selector: '*[data-glightbox]',
								openEffect: 'fade',
								closeEffect: 'fade'
						});
				}
		},
		// END: GLightbox

		// START: 07 Isotope
		enableIsotope: function () {
				var isGridItem = e.select('.grid-item');
				if (e.isVariableDefined(isGridItem)) {

						// Code only for normal Grid
						var onlyGrid = e.select('[data-isotope]');
						if (e.isVariableDefined(onlyGrid)) {
								var allGrid = e.selectAll("[data-isotope]");
								allGrid.forEach(gridItem => {
										var gridItemData = gridItem.getAttribute('data-isotope');
										var gridItemDataObj = JSON.parse(gridItemData);
										var iso = new Isotope(gridItem, {
												itemSelector: '.grid-item',
												layoutMode: gridItemDataObj.layoutMode
										});

										imagesLoaded(gridItem).on('progress', function () {
												// layout Isotope after each image loads
												iso.layout();
										});
								});
						}

						// Code only for normal Grid
						var onlyGridFilter = e.select('.grid-menu');
						if (e.isVariableDefined(onlyGridFilter)) {
								var filterMenu = e.selectAll('.grid-menu');
								filterMenu.forEach(menu => {
										var filterContainer = menu.getAttribute('data-target');
										var a = menu.dataset.target;
										var b = e.select(a);
										var filterContainerItemData = b.getAttribute('data-isotope');
										var filterContainerItemDataObj = JSON.parse(filterContainerItemData);
										var filter = new Isotope(filterContainer, {
												itemSelector: '.grid-item',
												transitionDuration: '0.7s',
												layoutMode: filterContainerItemDataObj.layoutMode
										});

										var menuItems = menu.querySelectorAll('li a');
										menuItems.forEach(menuItem => {
												menuItem.addEventListener('click', function (event) {
														var filterValue = menuItem.getAttribute('data-filter');
														filter.arrange({filter: filterValue});
														menuItems.forEach((control) => control.removeClass('active'));
														menuItem.addClass('active');
												});
										});

										imagesLoaded(filterContainer).on('progress', function () {
												filter.layout();
										});
								});
						}

				}
		},
		// END: Isotope

		// START: 08 Choices
		choicesSelect: function () {
			var choice = e.select('.js-choice');
			
			if (e.isVariableDefined(choice)) {
				var element = document.querySelectorAll('.js-choice');

				element.forEach(function (item) {
					var removeItemBtn = item.getAttribute('data-remove-item-button') == 'true' ? true : false;
					var placeHolder = item.getAttribute('data-placeholder') == 'false' ? false : true;
					var placeHolderVal = item.getAttribute('data-placeholder-val') ? item.getAttribute('data-placeholder-val') : 'Type and hit enter';
					var maxItemCount = item.getAttribute('data-max-item-count') ? item.getAttribute('data-max-item-count') : 3;
					var searchEnabled = item.getAttribute('data-search-enabled') == 'false' ? false : true;

					var choices = new Choices(item, {
							removeItemButton: removeItemBtn,
							placeholder: placeHolder,
							placeholderValue: placeHolderVal,
							maxItemCount: maxItemCount,
							searchEnabled: searchEnabled
					});

				});
			}
	 },
	 // END: Choices

		// START: 09 AOS Animation
		aosFunc: function () {
				var aos = e.select('.aos');
				if (e.isVariableDefined(aos)) {
						AOS.init({
								duration: 500,
								easing: 'ease-out-quart',
								once: true
						});
				}
		},
		// END: AOS Animation

		};
e.init();